** set working folder
cd " C:\...\EDYI_slab4 "

** start log file
log using lab4.log, replace


******************************
*
*   merge/append datasets
*
******************************

** add observations
use data1, clear
count
describe
list

append using data2
count
describe
list

** add variables 
merge 1:1 id using data3

count
describe
list

tab _merge

save fin_data, replace



******************************
*
*  reshape data
*
******************************
use data_all, clear

rename pbef pres1
rename paft pres2

reshape long pres, i(id) j(time)

reshape wide pres, i(id) j(time)



**************************************
*
*  looping over variables / numbers
*
**************************************
encode gender, gen(sex)
replace weigh=. if weigh<0
replace heigh=. if heigh>500
replace alcohol=. if alcoh==9


** Variables
*********************************
foreach var of varlist weight-pressure pbef paft {
	display " === `var' ==="
	ttest `var', by(sex)
}

foreach var of varlist weight-pressure pbef paft {
	sum `var'
	noisily display "`var'" _col(15) r(N) _col(20) %6.2f r(mean) _col(28) " (" %4.2f r(sd) ")"
}

** numbers
*********************************

forvalues i = 1/3 {
	pwcorr weight-pressure if alcohol==`i'
}

** double loop
forvalues i = 1/3 {
	foreach var of varlist weight-pressure pbef paft {
		quietly sum `var' if alcohol==`i'
		noisily display "`var', alc: `i'" _col(20) r(N) _col(25) %6.2f r(mean) _col(26) " (" %4.2f r(sd) ")"
	}
}

** display value label for categorical var

lab define alclab 1 no 2 low 3 high
lab values alcoh alclab


forvalues i = 1/3 {
	noisily display " alc: `:label (alcohol) `i' ' "
	foreach var of varlist weight-pressure pbef paft {
		qui sum `var' if alcohol==`i'
		noi di "`var'" _col(20) r(N) _col(25) %6.2f r(mean) _col(31) " (" %4.2f r(sd) ")"
	}
}



**************************************
*
*  Random number / variables
*
**************************************

* generate random numbers / uniform distribution
*****************************************
drop _all
set obs 30

** create id code (1,2,3,...,30)
gen id=_n

** create variable ~ uniform distr
gen u=runiform()

** make random sample repeatable
set seed 1234
gen u1=runiform()

set seed 1234
gen u2=runiform()
li

** get random sample
sort u
li


** generate variable ~ normal distr
****************************************
drop _all
set obs 1000

gen n=rnormal()
sum n
hist n

gen n1=rnormal(25, 3)
sum n1
hist n1
